/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/
package cnrg.itx.ds;

/**
 * This class stores information on userID, extension, roaming location (if any), and custom message.
 */
public class UserProperty 
{
	// private data members
	private UserID m_userID;
	private int m_ext;
	private Location m_roamLoc;
	private String m_customMsg;
	
	/**
	 * Constructor 
	 * @param id - UserID object
	 * @param extension - integer value of the extension number
	 * @param roamLoc - roaming location
	 * @param customMsg - custom message
	 */
	public UserProperty(UserID id, int extension, Location roamLoc, String customMsg) {
		m_userID = id;
		m_ext = extension;
		m_roamLoc = roamLoc;
		m_customMsg = customMsg;
	}
	
	/**
	 * Gets userID field
	 * @return a UserID object
	 */
	public UserID getUserID() {
		return m_userID;
	}
	
	/**
	 * Gets extension field
	 * @return an int to represent an extension
	 */
	public int getExtension() {
		return m_ext;
	}
	
	/**
	 * Gets roaming location object (if any)
	 * @return a roaming location object
	 */
	public Location getRoamingLocation() {
		return m_roamLoc;
	}
	
	/**
	 * Gets custom message
	 * @return a string object
	 */
	public String getCustomMessage() {
		return m_customMsg;
	}
}